
'''
Die angelegte Bibliothek setup_ai ist die Schnittstelle zwischen dem Sprachmodell
und den User-Anfragen.
Sie enthaelt Funktionen, um einfach oder aufeinander aufbauende Anfragen zu beantworten.
Außerdem kann in dieser Bibliothek die Funktion des Chatbots spezifiziert werden.
'''

# Importieren der noetigen Bibliotheken
import os
import openai

# API einrichten
# YOUR_API_KEY durch Ihren persoenlichen Key ersetzen
openai.api_key = 'YOUR_API_KEY'

# Die Liste context ist wie das Gedaechtnis des Sprachmodells, hier werden alle Anfragen und darauf
# gelierferten Antworten gespeichert.
# Zusaetzlich kann context speichern, welche Aufgaben der Chatbot übernehmen soll und ihm dafür nötige
# Aufgaben und Angaben liefern.
context = [ {'role':'system', 'content':"""
You are a bot to help the user write code in Python.\
If the user starts a general conversation, inform them about your purpose.\
Structure your output as following, if the user requests a written code example:\
Briefly, sum up what purpose the code is supposed to follow.\
Then, provide the code solution.\
Proceed to explain the code.\
Finally, ask whether the user has any more questions left.\
If not, inform the user that they should try the code and see whether it works.\
Please inform the user to check the correct names of variables when giving a code example.\
"""} ] # Sammelt bisherige Abfragen und Antworten

def get_completion(prompt, model="gpt-3.5-turbo") -> str:
    '''
    get_completion() kann das Sprachmodell eine Frage (prompt) beantworten.
    Die Antwort wird als String zurueckgegeben.
    '''
    messages = [{"role": "user", "content": prompt}]
    response = openai.ChatCompletion.create(
        model=model, # Genutztes Sprachmodell
        messages=messages,
        temperature=0, # Differenziertheit der Antwort
    )
    return response.choices[0].message["content"]

def get_completion_from_messages(messages, model="gpt-3.5-turbo", temperature=0) -> str:
    '''
    get_completion_from_messages() ermoeglicht es, mit dem Sprachmodell ein aufeinander aufbauendes Gespraech
    zu fuehren. Dafuer wird die bisherige Konversation mit der Variable messages aufgerufen.
    Die Antwort hier wird ebenfalls als String zurueckgegeben.
    '''
    response = openai.ChatCompletion.create(
        model=model, # Genutztes Sprachmodell
        messages=messages,
        temperature=temperature, # Differenziertheit der Antwort
    )
    return response.choices[0].message["content"]

def collect_input(prompt) -> None:
    '''
    collect_input() wird genutzt, um alle Anfragen in der Liste context zu speichern, damit das Gespraech
    aufeinander aufbauend gestaltet werden kann.
    '''
    context.append({'role':'user', 'content':f"{prompt}"})

def collect_responses(response) -> None:
    '''
    collect_responses() funktioniert aehnlich wie collect_input(), allerdings werden hier die Antworten
    des Sprachmodells der Liste context hinzugefuegt.
    '''
    context.append({'role':'assistant', 'content':f"{response}"})
